<?php
require __DIR__ . '/../includes/auth_check.php';
require __DIR__ . '/../config/db.php';

$periodo = $_GET['periodo'] ?? 'mes';
$exportar = isset($_GET['exportar']) && $_GET['exportar'] === 'excel';

// Función para traducir unidad
function traducirUnidad($u) {
    switch ($u) {
        case 'm': return 'Metros';
        case 'kg': return 'Kilos';
        case 'u': return 'Unidades';
        default: return $u;
    }
}

if ($periodo === 'stock') {
    // Reporte de todo el stock actual
    $sql = "
        SELECT c.codigo, c.descripcion, c.unidad, c.precio_unitario, c.stock, cat.nombre AS categoria
        FROM cintas c
        LEFT JOIN categorias cat ON c.categoria_id = cat.id
        ORDER BY cat.nombre, c.codigo
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $reporte = $stmt->fetchAll();
    $titulo = "Reporte de Todo el Stock";
} else {
    // Reportes de movimientos (semana, mes, año)
    switch ($periodo) {
        case 'semana':
            $condicion = "YEARWEEK(m.fecha, 1) = YEARWEEK(CURDATE(), 1)";
            $titulo = "Reporte Semanal";
            break;
        case 'anio':
            $condicion = "YEAR(m.fecha) = YEAR(CURDATE())";
            $titulo = "Reporte Anual";
            break;
        default:
            $condicion = "MONTH(m.fecha) = MONTH(CURDATE()) AND YEAR(m.fecha) = YEAR(CURDATE())";
            $titulo = "Reporte Mensual";
            break;
    }

    $sql = "
        SELECT c.codigo, c.descripcion, c.unidad, c.precio_unitario,
               SUM(CASE WHEN m.tipo = 'ingreso' THEN m.cantidad ELSE -m.cantidad END) AS movimiento_total
        FROM movimientos m
        JOIN cintas c ON m.cinta_id = c.id
        WHERE $condicion
        GROUP BY c.id, c.codigo, c.descripcion, c.unidad, c.precio_unitario
        ORDER BY c.codigo
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $reporte = $stmt->fetchAll();
}

// Exportar a Excel
if ($exportar) {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=reporte_$periodo.xls");

    echo "<table border='1'>";
    if ($periodo === 'stock') {
        echo "<tr><th>Categoría</th><th>Código</th><th>Descripción</th><th>Unidad</th><th>Precio Unitario</th><th>Stock</th></tr>";
        foreach ($reporte as $r) {
            echo "<tr>";
            echo "<td>".htmlspecialchars($r['categoria'])."</td>";
            echo "<td>".htmlspecialchars($r['codigo'])."</td>";
            echo "<td>".htmlspecialchars($r['descripcion'])."</td>";
            echo "<td>".traducirUnidad($r['unidad'])."</td>";
            echo "<td>$".number_format($r['precio_unitario'], 0, '', '.')." CLP</td>";
            echo "<td>".number_format($r['stock'], 0, '', '.')." ".traducirUnidad($r['unidad'])."</td>";
            echo "</tr>";
        }
    } else {
        echo "<tr><th>Código</th><th>Descripción</th><th>Unidad</th><th>Precio Unitario</th><th>Movimiento Total</th><th>Valor Total</th></tr>";
        foreach ($reporte as $r) {
            echo "<tr>";
            echo "<td>".htmlspecialchars($r['codigo'])."</td>";
            echo "<td>".htmlspecialchars($r['descripcion'])."</td>";
            echo "<td>".traducirUnidad($r['unidad'])."</td>";
            echo "<td>$".number_format($r['precio_unitario'], 0, '', '.')." CLP</td>";
            echo "<td>".number_format($r['movimiento_total'], 0, '', '.')." ".traducirUnidad($r['unidad'])."</td>";
            echo "<td>$".number_format($r['movimiento_total'] * $r['precio_unitario'], 0, '', '.')." CLP</td>";
            echo "</tr>";
        }
    }
    echo "</table>";
    exit;
}

include __DIR__ . '/../includes/header.php';
?>
<h3 class="mb-4"><?= $titulo ?></h3>

<div class="mb-3">
  <a href="?periodo=semana" class="btn btn-info">📅 Reporte Semanal</a>
  <a href="?periodo=mes" class="btn btn-warning">📊 Reporte Mensual</a>
  <a href="?periodo=anio" class="btn btn-success">📈 Reporte Anual</a>
  <a href="?periodo=stock" class="btn btn-secondary">📦 Reporte de Todo el Stock</a>
  <a href="?periodo=<?= $periodo ?>&exportar=excel" class="btn btn-primary">⬇️ Exportar a Excel</a>
</div>

<table class="table table-striped table-hover shadow-sm">
  <thead class="table-primary">
    <?php if ($periodo === 'stock'): ?>
      <tr>
        <th>Categoría</th>
        <th>Código</th>
        <th>Descripción</th>
        <th>Unidad</th>
        <th>Precio Unitario</th>
        <th>Stock</th>
      </tr>
    <?php else: ?>
      <tr>
        <th>Código</th>
        <th>Descripción</th>
        <th>Unidad</th>
        <th>Precio Unitario</th>
        <th>Movimiento Total</th>
        <th>Valor Total</th>
      </tr>
    <?php endif; ?>
  </thead>
  <tbody>
    <?php if (empty($reporte)): ?>
      <tr><td colspan="6" class="text-center">No se encontraron datos.</td></tr>
    <?php else: ?>
      <?php foreach ($reporte as $r): ?>
        <?php if ($periodo === 'stock'): ?>
          <tr>
            <td><?= htmlspecialchars($r['categoria']) ?></td>
            <td><?= htmlspecialchars($r['codigo']) ?></td>
            <td><?= htmlspecialchars($r['descripcion']) ?></td>
            <td><?= traducirUnidad($r['unidad']) ?></td>
            <td>$<?= number_format($r['precio_unitario'], 0, '', '.') ?> CLP</td>
            <td><?= number_format($r['stock'], 0, '', '.') ?> <?= traducirUnidad($r['unidad']) ?></td>
          </tr>
        <?php else: ?>
          <tr>
            <td><?= htmlspecialchars($r['codigo']) ?></td>
            <td><?= htmlspecialchars($r['descripcion']) ?></td>
            <td><?= traducirUnidad($r['unidad']) ?></td>
            <td>$<?= number_format($r['precio_unitario'], 0, '', '.') ?> CLP</td>
            <td><?= number_format($r['movimiento_total'], 0, '', '.') ?> <?= traducirUnidad($r['unidad']) ?></td>
            <td>$<?= number_format($r['movimiento_total'] * $r['precio_unitario'], 0, '', '.') ?> CLP</td>
          </tr>
        <?php endif; ?>
      <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>